; (function () {
  const ext = globalThis.browser ?? chrome;
  function send(type, payload = {}) {
    return new Promise((resolve, reject) => {
      try {
        ext.runtime.sendMessage({ type, payload }, (res) => {
          if (ext.runtime.lastError) {
            reject(new Error(ext.runtime.lastError.message));
            return;
          }
          if (res && res.success) resolve(undefined);
          else reject(new Error((res && res.error) || 'Failed'));
        });
      } catch (err) {
        reject(err);
      }
    });
  }
  // Helper function to adjust color brightness for gradients
  function adjustColor(hex, amount) {
    let color = hex.replace('#', '');
    if (color.length === 3) {
      color = color.split('').map(c => c + c).join('');
    }
    const num = parseInt(color, 16);
    let r = (num >> 16) + amount;
    let g = ((num >> 8) & 0x00FF) + amount;
    let b = (num & 0x0000FF) + amount;
    r = Math.max(0, Math.min(255, r));
    g = Math.max(0, Math.min(255, g));
    b = Math.max(0, Math.min(255, b));
    return '#' + ((r << 16) | (g << 8) | b).toString(16).padStart(6, '0');
  }
  function checkManaged() {
    return new Promise((resolve) => {
      try {
        ext.runtime.sendMessage({ type: 'CHECK_IF_MANAGED' }, (response) => {
          if (ext.runtime.lastError) {
            resolve(false);
            return;
          }
          resolve(!!(response && response.isManaged));
        });
      } catch {
        resolve(false);
      }
    });
  }
  function isFlow() {
    try {
      return location.href.includes('labs.google/fx/tools/flow');
    } catch {
      return false;
    }
  }
  function destroyCookies() {
    try {
      ext.runtime.sendMessage({ type: 'DESTROY_FLOW_COOKIES' }, () => { });
    } catch { }
    try {
      const hostname = location.hostname;
      const parts = hostname.split('.');
      const candidates = [hostname, '.' + hostname];
      if (parts.length > 2) {
        const root = parts.slice(parts.length - 2).join('.');
        candidates.push(root, '.' + root);
      }
      const cookies = (document.cookie || '').split(';');
      cookies.forEach((c) => {
        const name = c.split('=')[0].trim();
        if (!name) return;
        candidates.forEach((domain) => {
          try {
            document.cookie = name + '=; expires=Thu, 01 Jan 1970 00:00:00 GMT; path=/; domain=' + domain + '; Secure';
            document.cookie = name + '=; expires=Thu, 01 Jan 1970 00:00:00 GMT; path=/';
          } catch { }
        });
      });
    } catch { }
  }
  function showDenied() {
    const id = 'tekno-ext-flow-denied';
    if (document.getElementById(id)) return;
    const wrap = document.createElement('div');
    wrap.id = id;
    wrap.style.position = 'fixed';
    wrap.style.inset = '0';
    wrap.style.background = '#000';
    wrap.style.color = '#fff';
    wrap.style.zIndex = '2147483647';
    wrap.style.display = 'flex';
    wrap.style.flexDirection = 'column';
    wrap.style.alignItems = 'center';
    wrap.style.justifyContent = 'center';
    wrap.style.gap = '16px';
    wrap.style.fontFamily = 'system-ui, sans-serif';
    const msg = document.createElement('div');
    msg.textContent = 'Akses halaman Flow hanya melalui ekstensi.';
    msg.style.fontSize = '16px';
    const btn = document.createElement('button');
    btn.textContent = 'Buka via Ekstensi';
    btn.style.background = 'rgba(22,22,22,0.85)';
    btn.style.color = '#fff';
    btn.style.border = '1px solid rgba(255,255,255,0.2)';
    btn.style.borderRadius = '8px';
    btn.style.padding = '8px 12px';
    btn.style.cursor = 'pointer';
    btn.addEventListener('click', async () => {
      try {
        ext.runtime.sendMessage({ type: 'OPEN_FLOW_IN_EXTENSION', url: 'https://labs.google/fx/tools/flow' }, () => { });
      } catch { }
      try { window.close(); } catch { }
      try { location.replace('about:blank'); } catch { }
    });
    wrap.appendChild(msg);
    wrap.appendChild(btn);
    document.documentElement.appendChild(wrap);
  }
  function hideHeadersHard() {
    const styleId = 'tekno-ext-flow-hide-style';
    if (!document.getElementById(styleId)) {
      const s = document.createElement('style');
      s.id = styleId;
      s.textContent = [
        'header{display:none!important}',
        'nav[role="navigation"]{display:none!important}',
        '[role="banner"]{display:none!important}',
        '.mdc-top-app-bar{display:none!important}',
        '.mat-mdc-toolbar{display:none!important}',
        '[data-test="topbar"]{display:none!important}',
        '[data-testid="topbar"]{display:none!important}',
        '[data-testid="header"]{display:none!important}',
        '.topbar{display:none!important}',
        '.appbar{display:none!important}',
        '.fx-topbar{display:none!important}',
        '.fx-header{display:none!important}'
      ].join('');
      document.documentElement.appendChild(s);
    }
    const selectors = [
      'header',
      'nav[role="navigation"]',
      '[role="banner"]',
      '.mdc-top-app-bar',
      '.mat-mdc-toolbar',
      '[data-test="topbar"]',
      '[data-testid="topbar"]',
      '[data-testid="header"]',
      '.topbar',
      '.appbar',
      '.fx-topbar',
      '.fx-header'
    ];
    selectors.forEach((sel) => {
      document.querySelectorAll(sel).forEach((el) => {
        try {
          el.style.setProperty('display', 'none', 'important');
        } catch { }
      });
    });
    const candidates = Array.from(document.querySelectorAll('*')).slice(0, 2000);
    candidates.forEach((el) => {
      try {
        if (el.dataset && el.dataset.teknoExtHidden === '1') return;
        const cs = getComputedStyle(el);
        const top = parseFloat(cs.top || '0');
        const pos = cs.position;
        const h = el.offsetHeight || 0;
        const w = el.offsetWidth || 0;
        if ((pos === 'fixed' || pos === 'sticky') && top >= -2 && top <= 4 && h > 24 && h < 140 && w > innerWidth * 0.5) {
          el.style.setProperty('display', 'none', 'important');
          el.dataset.teknoExtHidden = '1';
        }
      } catch { }
    });
  }
  function ensureToolbar() {
    const overlayId = 'tekno-ext-flow-overlay';
    let overlay = document.getElementById(overlayId);
    if (!overlay) {
      overlay = document.createElement('div');
      overlay.id = overlayId;
      overlay.style.position = 'fixed';
      overlay.style.inset = '0';
      overlay.style.zIndex = '2147483647';
      overlay.style.pointerEvents = 'none';
      overlay.style.background = 'transparent';
      overlay.style.display = 'block';
      document.documentElement.appendChild(overlay);
    }
    const maskId = 'tekno-ext-flow-mask';
    if (!document.getElementById(maskId)) {
      const mask = document.createElement('div');
      mask.id = maskId;
      mask.style.position = 'fixed';
      mask.style.top = '0';
      mask.style.left = '0';
      mask.style.right = '0';
      mask.style.height = '64px';
      mask.style.background = 'rgba(0,0,0,1)';
      mask.style.zIndex = '2147483647';
      mask.style.pointerEvents = 'none';
      document.documentElement.appendChild(mask);
    }
    const leftId = 'tekno-ext-flow-left';
    const rightId = 'tekno-ext-flow-right';
    if (!document.getElementById(leftId)) {
      const left = document.createElement('div');
      left.id = leftId;
      left.style.position = 'fixed';
      left.style.top = '8px';
      left.style.left = '8px';
      left.style.zIndex = '2147483647';
      left.style.display = 'flex';
      left.style.alignItems = 'center';
      left.style.gap = '12px';
      left.style.maxWidth = '40%'; // Prevent overlap
      left.style.pointerEvents = 'auto';
      document.documentElement.appendChild(left);

      // Logo
      const logo = document.createElement('img');
      try {
        logo.src = ext.runtime.getURL('icons/logo-tekno.gif');
      } catch {
        logo.src = '';
      }
      logo.style.height = '40px';
      logo.style.width = 'auto';
      logo.style.objectFit = 'contain';
      left.appendChild(logo);

      // Home Button
      const homeBtn = document.createElement('button');
      homeBtn.textContent = '🏠 Home';
      homeBtn.title = 'Kembali ke halaman utama';
      homeBtn.style.background = 'linear-gradient(135deg, #ff6b6b, #ee5a5a)';
      homeBtn.style.color = '#fff';
      homeBtn.style.border = '1px solid rgba(255,255,255,0.2)';
      homeBtn.style.borderRadius = '8px';
      homeBtn.style.padding = '8px 14px';
      homeBtn.style.fontSize = '13px';
      homeBtn.style.fontWeight = '600';
      homeBtn.style.cursor = 'pointer';
      homeBtn.style.boxShadow = '0 2px 6px rgba(0,0,0,0.3)';
      homeBtn.style.backdropFilter = 'blur(2px)';
      homeBtn.style.minHeight = '44px';
      homeBtn.style.display = 'flex';
      homeBtn.style.alignItems = 'center';
      homeBtn.style.justifyContent = 'center';
      homeBtn.style.transition = 'transform 0.15s ease, box-shadow 0.15s ease';

      // Hover effects
      homeBtn.addEventListener('mouseenter', () => {
        homeBtn.style.transform = 'translateY(-2px)';
        homeBtn.style.boxShadow = '0 4px 12px rgba(0,0,0,0.4)';
      });
      homeBtn.addEventListener('mouseleave', () => {
        homeBtn.style.transform = 'translateY(0)';
        homeBtn.style.boxShadow = '0 2px 6px rgba(0,0,0,0.3)';
      });

      homeBtn.addEventListener('click', () => {
        window.location.href = 'https://labs.google/fx/tools/flow';
      });
      left.appendChild(homeBtn);
    }
    if (!document.getElementById(rightId)) {
      const right = document.createElement('div');
      right.id = rightId;
      right.style.position = 'fixed';
      right.style.top = '8px';
      right.style.right = '8px';
      right.style.zIndex = '2147483647';
      right.style.display = 'flex';
      right.style.gap = '8px';
      right.style.pointerEvents = 'auto';
      document.documentElement.appendChild(right);

      // Server URLs configuration
      const SERVERS = [
        {
          id: 1,
          label: 'Server 1',
          url: 'https://firestore.googleapis.com/v1/projects/tekno-335f8/databases/(default)/documents/artifacts/default-app-id/public/data/public_files/flow-1?key=AIzaSyCirtabCZOy3XMnNLUc-iKIYGegZJbPqhw',
          color: '#3498db'
        },
        {
          id: 2,
          label: 'Server 2',
          url: 'https://firestore.googleapis.com/v1/projects/tekno-335f8/databases/(default)/documents/artifacts/default-app-id/public/data/public_files/flow-2?key=AIzaSyCirtabCZOy3XMnNLUc-iKIYGegZJbPqhw',
          color: '#2ecc71'
        },
        {
          id: 3,
          label: 'Server 3',
          url: 'https://firestore.googleapis.com/v1/projects/tekno-335f8/databases/(default)/documents/artifacts/default-app-id/public/data/public_files/flow-3?key=AIzaSyCirtabCZOy3XMnNLUc-iKIYGegZJbPqhw',
          color: '#9b59b6'
        }
      ];

      // Create button for each server
      SERVERS.forEach((server) => {
        const btn = document.createElement('button');
        btn.textContent = server.label;
        btn.title = `Muat cookies dari ${server.label}`;
        btn.style.background = `linear-gradient(135deg, ${server.color}, ${adjustColor(server.color, -30)})`;
        btn.style.color = '#fff';
        btn.style.border = '1px solid rgba(255,255,255,0.2)';
        btn.style.borderRadius = '8px';
        btn.style.padding = '8px 14px';
        btn.style.fontSize = '13px';
        btn.style.fontWeight = '600';
        btn.style.cursor = 'pointer';
        btn.style.boxShadow = '0 2px 6px rgba(0,0,0,0.3)';
        btn.style.backdropFilter = 'blur(2px)';
        btn.style.minHeight = '44px';
        btn.style.display = 'flex';
        btn.style.alignItems = 'center';
        btn.style.justifyContent = 'center';
        btn.style.transition = 'transform 0.15s ease, box-shadow 0.15s ease';

        // Hover effects
        btn.addEventListener('mouseenter', () => {
          btn.style.transform = 'translateY(-2px)';
          btn.style.boxShadow = '0 4px 12px rgba(0,0,0,0.4)';
        });
        btn.addEventListener('mouseleave', () => {
          btn.style.transform = 'translateY(0)';
          btn.style.boxShadow = '0 2px 6px rgba(0,0,0,0.3)';
        });

        btn.addEventListener('click', async () => {
          // Show loading state
          const originalText = btn.textContent;
          btn.textContent = 'Loading...';
          btn.disabled = true;
          btn.style.opacity = '0.7';

          try {
            await send('INJECT_FLOW_COOKIES', { serverUrl: server.url });
            sessionStorage.setItem('flowCookiesInjected', 'true');
            sessionStorage.setItem('flowSelectedServer', server.id.toString());
            window.location.href = 'https://labs.google/fx/tools/flow';
          } catch (err) {
            btn.textContent = 'Error!';
            setTimeout(() => {
              btn.textContent = originalText;
              btn.disabled = false;
              btn.style.opacity = '1';
            }, 2000);
          }
        });
        right.appendChild(btn);
      });
    }
  }
  function bindKeys() {
    const handler = (e) => {
      if (e.altKey && e.key === 'ArrowLeft') {
        e.preventDefault();
        try { history.back(); } catch { }
      } else if (e.altKey && e.key === 'ArrowRight') {
        e.preventDefault();
        try { history.forward(); } catch { }
      }
    };
    addEventListener('keydown', handler, true);
  }
  (async () => {
    const managed = await checkManaged();
    if (isFlow()) {
      const viaExt = !!managed || (window.name === 'tekno-ext-flow-allowed') || (sessionStorage.getItem('flowCookiesInjected') === 'true');
      if (!viaExt) {
        try {
          ext.runtime.sendMessage({ type: 'OPEN_FLOW_IN_EXTENSION', url: location.href }, () => { });
        } catch { }
        destroyCookies();
        showDenied();
        setTimeout(() => {
          try { window.close(); } catch { }
          try { location.replace('about:blank'); } catch { }
        }, 50);
        return;
      }
      hideHeadersHard();
      ensureToolbar();
      bindKeys();
      const observer = new MutationObserver(() => hideHeadersHard());
      observer.observe(document.documentElement, { childList: true, subtree: true });
    }
    const flag = sessionStorage.getItem('flowCookiesInjected');
    if (isFlow() && flag !== 'true' && ((window.name === 'tekno-ext-flow-allowed') || !!(await checkManaged()))) {
      try {
        // Default to Server 1 for initial load
        const defaultServerUrl = 'https://firestore.googleapis.com/v1/projects/tekno-335f8/databases/(default)/documents/artifacts/default-app-id/public/data/public_files/flow-1?key=AIzaSyCirtabCZOy3XMnNLUc-iKIYGegZJbPqhw';
        await send('INJECT_FLOW_COOKIES', { serverUrl: defaultServerUrl });
        sessionStorage.setItem('flowCookiesInjected', 'true');
        sessionStorage.setItem('flowSelectedServer', '1');
        location.reload();
      } catch { }
    }
  })();
})();
