;(function() {
  const ext = globalThis.browser ?? chrome;
  const TARGET_URL = "https://labs.google/fx/tools/flow";
  function clickHandler(e) {
    const a = e.target && (e.target.closest && e.target.closest('a[href*="labs.google/fx/tools/flow"]')) || null;
    if (!a) return;
    e.preventDefault();
    const send = () => new Promise((resolve, reject) => {
      try {
        ext.runtime.sendMessage({ type: 'INJECT_FLOW_COOKIES' }, (res) => {
          if (ext.runtime.lastError) {
            reject(new Error(ext.runtime.lastError.message));
            return;
          }
          if (res && res.success) resolve(undefined);
          else reject(new Error(res && res.error || 'Injection failed'));
        });
      } catch (err) {
        reject(err);
      }
    });
    send().finally(() => {
      location.href = TARGET_URL;
    });
  }
  addEventListener('click', clickHandler, true);
})(); 
