

(function () {
    const ext = globalThis.browser ?? chrome;

    /**
     * This function contains all the UI modification logic.
     * It will only be executed if the script is running in a tab
     * managed by the extension's popup window.
     */
    function initializeGudangbotUI() {
      // Fungsi deteksi seluler telah dihapus untuk mendukung browser seluler.
      
      // kata kunci yang mau di-hide
      const WORDS = ["copy", "share", "export", "good response", "bad response", "modify response", "report", "regenerate", "microphone", "upload file"]; // case-insensitive

      const norm = s => (s || "").replace(/\s+/g, " ").trim().toLowerCase();

      // hanya evaluasi ELEMEN INTERAKTIF, bukan div/span generik
      const SELECTORS = 'button, [role="button"], a, [role="tab"], input[type="button"], input[type="submit"]';

      function textMatch(el) {
        const labels = [
          el.innerText,
          el.value,
          el.textContent,
          el.getAttribute?.("aria-label"),
          el.getAttribute?.("title")
        ].map(norm).filter(Boolean);
        if (!labels.length) return false;
        return labels.some(t => WORDS.some(w => t.includes(w)));
      }

      function hideEl(el) {
        if (!el || el.__hiddenClean) return;
        el.__hiddenClean = true;
        el.style.setProperty("display", "none", "important");
      }

      function hideButtons(root = document) {
        root.querySelectorAll(SELECTORS).forEach(el => {
          if (textMatch(el)) hideEl(el);
        });
      }

      /**
       * Creates and appends the content (back button and link) for the top mask.
       * @param {HTMLElement} mask The mask element to append content to.
       */
      function createTopMaskContent(mask) {
        const backButton = document.createElement('a');
        backButton.id = 'kembali-btn';
        backButton.textContent = 'Kembali';
        backButton.addEventListener('click', () => {
          window.location.href = 'https://gudangbot.com/rawon/verify.html';
        });

        const link = document.createElement("a");
        link.id = "gudangbot-com-link";
        link.textContent = "gudangbot.com";
        link.addEventListener('click', () => {
          window.open('https://gudangbot.com', '_blank', 'noopener,noreferrer');
        });
        
        mask.appendChild(backButton);
        mask.appendChild(link);
      }

      function applyTopMaskIfNeeded() {
        if (window.location.hostname === "aistudio.google.com") {
          // Add top mask element
          if (!document.getElementById("clean-viewer-top-mask")) {
            const mask = document.createElement("div");
            mask.id = "clean-viewer-top-mask";
            createTopMaskContent(mask);
            document.body.appendChild(mask);
          }
          // Add a class to the root element for CSS styling
          document.documentElement.classList.add('has-top-mask');
        }
      }

      function applyChatGptTopMask() {
        if (window.location.hostname === "chatgpt.com" || window.location.hostname === "sora.chatgpt.com") {
          if (!document.getElementById("clean-viewer-chatgpt-top-mask")) {
            const mask = document.createElement("div");
            mask.id = "clean-viewer-chatgpt-top-mask";
            createTopMaskContent(mask);
            document.body.appendChild(mask);
          }
        }
      }

      /*
      function handleResize() {
        // Resize check removed to support mobile browsers where window size is fixed.
      }
      */

      function scan(root = document) {
        hideButtons(root);
        applyTopMaskIfNeeded();
        applyChatGptTopMask();
      }

      // Initial
      scan(document);
      handleResize(); // Check on initial load

      // Observer: hanya perhatikan node interaktif/atribut yang relevan
      const mo = new MutationObserver(muts => {
        for (const m of muts) {
          if (m.type === "childList") {
            m.addedNodes.forEach(n => {
              if (n.nodeType === 1) {
                // hanya scan subtree baru
                scan(n);
              }
            });
          } else if (m.type === "attributes") {
            const el = m.target;
            // Pastikan target memang elemen interaktif
            if (el.matches?.(SELECTORS) && textMatch(el)) hideEl(el);
          }
        }
      });

      mo.observe(document.documentElement, {
        subtree: true,
        childList: true,
        attributes: true,
        attributeFilter: ["aria-label", "title", "value"]
      });
    }

    /**
     * Checks if the current tab is managed by the extension.
     * Caches the result in sessionStorage to avoid repeated checks.
     * If managed, it calls the function to apply UI modifications.
     */
    function checkAndInitialize() {
        const isManagedSession = sessionStorage.getItem('isManagedByGudangbot');

        if (isManagedSession === 'true') {
            initializeTeknoFlowUI();
        } else if (isManagedSession === 'false') {
            // It's not a managed tab, do nothing.
            return;
        } else {
            // Flag not set, ask the background script.
            if (ext && ext.runtime && typeof ext.runtime.sendMessage === 'function') {
                ext.runtime.sendMessage({ type: 'CHECK_IF_MANAGED' }, (response) => {
                    if (ext.runtime.lastError) {
                        console.warn("Gudangbot: ", ext.runtime.lastError.message);
                        sessionStorage.setItem('isManagedByGudangbot', 'false');
                        return;
                    }
                    
                    const isManaged = !!(response && response.isManaged);
                    sessionStorage.setItem('isManagedByGudangbot', String(isManaged));

                    if (isManaged) {
                        initializeTeknoFlowUI();
                    }
                });
            } else {
                // Assume not managed if extension APIs aren't available.
                sessionStorage.setItem('isManagedByGudangbot', 'false');
            }
        }
    }

    checkAndInitialize();
})();