/**
 * @license
 * SPDX-License-Identifier: Apache-2.0
*/

(function() {
  'use strict';
  
  // Gunakan `ext` sebagai alias lintas-peramban untuk `chrome` atau `browser`.
  const ext = globalThis.browser ?? chrome;

  // Fungsi deteksi seluler telah dihapus sepenuhnya.
  /*
  if (detectAndBlockMobile()) {
    return;
  }
  */


  /**
   * Fungsi ini berisi semua logika anti-inspeksi.
   * Ini hanya akan dijalankan jika skrip berjalan di tab
   * yang dikelola oleh jendela popup ekstensi.
   */
  function applyAntiInspect() {
    // Cara yang lebih kuat untuk mencegah tindakan default.
    const preventAction = (e) => {
      e.preventDefault();
      e.stopPropagation();
    };

    // Nonaktifkan menu konteks klik kanan
    window.addEventListener('contextmenu', preventAction, true);

    // Nonaktifkan pintasan keyboard untuk alat pengembang
    window.addEventListener('keydown', (e) => {
      // F12
      if (e.key === 'F12' || e.keyCode === 123) {
        preventAction(e);
      }

      // Ctrl+Shift+I (Inspect)
      if (e.ctrlKey && e.shiftKey && (e.key === 'I' || e.keyCode === 73)) {
        preventAction(e);
      }

      // Ctrl+Shift+J (Console)
      if (e.ctrlKey && e.shiftKey && (e.key === 'J' || e.keyCode === 74)) {
        preventAction(e);
      }

      // Ctrl+Shift+C (Elements)
      if (e.ctrlKey && e.shiftKey && (e.key === 'C' || e.keyCode === 67)) {
        preventAction(e);
      }

      // Ctrl+U (View Source)
      if (e.ctrlKey && (e.key === 'U' || e.keyCode === 85)) {
        preventAction(e);
      }
    }, true);
  }

  /**
   * Memeriksa apakah tab saat ini dikelola oleh ekstensi.
   * Menyimpan hasilnya di sessionStorage untuk menghindari pemeriksaan berulang.
   * Jika dikelola, fungsi ini akan memanggil fungsi untuk menerapkan perlindungan.
   */
  function checkAndInitialize() {
    const isManagedSession = sessionStorage.getItem('isManagedByGudangbot');

    if (isManagedSession === 'true') {
        applyAntiInspect();
    } else if (isManagedSession === 'false') {
        // Ini bukan tab yang dikelola, jangan lakukan apa pun.
        return;
    } else {
        // Bendera belum diatur, tanyakan pada skrip latar belakang.
        if (ext && ext.runtime && typeof ext.runtime.sendMessage === 'function') {
            ext.runtime.sendMessage({ type: 'CHECK_IF_MANAGED' }, (response) => {
                if (ext.runtime.lastError) {
                    console.warn("Tekno FLOW: ", ext.runtime.lastError.message);
                    sessionStorage.setItem('isManagedByGudangbot', 'false');
                    return;
                }
                
                const isManaged = !!(response && response.isManaged);
                sessionStorage.setItem('isManagedByGudangbot', String(isManaged));

                if (isManaged) {
                    applyAntiInspect();
                }
            });
        } else {
            // Asumsikan tidak dikelola jika API ekstensi tidak tersedia.
            sessionStorage.setItem('isManagedByGudangbot', 'false');
        }
    }
  }

  checkAndInitialize();
})();